globals[flag number-contagion N]
extensions[nw]

to setup
  clear-all
  set-default-shape turtles "circle"
  nw:set-context turtles links
  ;; make the initial network of two turtles and an edge
  make-node nobody        ;; first node, unattached
  make-node turtle 0      ;; second node, attached to first node
  reset-ticks
end

;; Main procedure
to go
  ;; new edge is green, old edges are gray
  set flag 0
  while [N < number-of-links]
  [
  ask links 
  [ set color gray ]
  make-node find-partner                                       
  tick
  if layout? [ layout ]
  ]
  
  ask one-of turtles 
  [set color green] ; when the model is finished, set one of the turtle's color to be green
  if any? turtles with [color = red] ;; when all turtles are affected, the model stops
  [
    ask turtles with [color = green] ;; ask the already-affected agents to spread the influence to other agents
    [
      ask link-neighbors [if random 100 <= probability-linked-affected 
        [set color green set flag 1] ;; based on the probability that direct networks are affected
        ask other turtles [
        if random 100 < probability-other-affected 
        [set color green set flag 1]]  ;; based on the probability that indirect networks are affected
      ]
    ]
    if flag = 1 
    [set number-contagion number-contagion + 1] 
  ]
end

;; used for creating a new node
to make-node [old-node]
  crt 1
  [
    set color red
    if old-node != nobody
      [ create-link-with old-node [ set color green ]
        ;; position the new node near its partner
        move-to old-node
        fd 8
        set N N + 1
      ]
  ]
end

to-report find-partner
  report [one-of both-ends] of one-of links
end

;;Layout
to resize-nodes
  ifelse all? turtles [size <= 1]
  [
    ask turtles [ set size sqrt count link-neighbors ]
  ]
  [
    ask turtles [ set size 1 ]
  ]
end

to layout
  repeat 3 [
    let factor sqrt count turtles
    layout-spring turtles links (1 / factor) (7 / factor) (1 / factor)
    display  
  ]
  let x-offset max [xcor] of turtles + min [xcor] of turtles
  let y-offset max [ycor] of turtles + min [ycor] of turtles
  set x-offset limit-magnitude x-offset 0.1
  set y-offset limit-magnitude y-offset 0.1
  ask turtles [ setxy (xcor - x-offset / 2) (ycor - y-offset / 2) ]
end

to-report limit-magnitude [number limit]
  if number > limit [ report limit ]
  if number < (- limit) [ report (- limit) ]
  report number
end
@#$#@#$#@
GRAPHICS-WINDOW
357
56
1030
750
45
45
7.29
1
10
1
1
1
0
0
0
1
-45
45
-45
45
1
1
1
ticks
60.0

BUTTON
6
25
72
58
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
6
64
91
97
go-once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
187
30
333
63
plot?
plot?
0
1
-1000

SWITCH
187
64
333
97
layout?
layout?
0
1
-1000

MONITOR
237
100
316
145
# of nodes
count turtles
3
1
11

BUTTON
7
102
109
135
redo layout
layout
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
115
102
225
135
resize nodes
resize-nodes
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
233
169
343
214
Average degree
sum [count link-neighbors] of turtles / count turtles
17
1
11

SLIDER
22
173
194
206
number-of-links
number-of-links
0
1000
96
1
1
NIL
HORIZONTAL

SLIDER
16
225
236
258
probability-linked-affected
probability-linked-affected
0
100
60
1
1
NIL
HORIZONTAL

SLIDER
19
280
236
313
probability-other-affected
probability-other-affected
0
100
0
1
1
NIL
HORIZONTAL

PLOT
6
357
206
507
betweenness centrality
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "if not plot? [stop]\nlet max-value max [nw:betweenness-centrality] of turtles\n;plotxy (count turtles) [nw:betweenness-centrality] of turtles\nplot-pen-reset  ;; erase what we plotted before\nset-plot-x-range 0 (max-value + 1) \n;set-plot-y-range \nhistogram [nw:betweenness-centrality] of turtles"

MONITOR
231
350
339
395
affected agents
count turtles with [color = green]
17
1
11

MONITOR
220
4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                