globals [ state px py vix viy earth themoon grav embarycenter]

breed [ earths anearth ]
breed [ moons moon ]
breed [ vectors vector ]
breed [ waters water ]
breed [ barycenters barycenter]
breed [ gravitations gravitation ]

turtles-own [ 
  mass    ; mass
  vx      ; velocity x
  vy      ; velocity y
  ax      ; tick acceleration x
  ay      ; tick accelration y 
  ]


to setup
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
  set-default-shape turtles "circle"


  create-gravitations 1
  [
    set hidden? true
  ]

  create-moons 1
  [
    set size 5
    set mass moon-mass
    ;; sets initial position
    setxy 15 100
    ;; sets initial velocity x y
    set vy -2
    set vx 3.5
    ;; moon's white, but this looks better
    set color gray
  ]

  create-earths 1 
  [
    ; inits earth
    set size 20
    set mass earth-mass
    setxy 0 0 
    set color green
    set vx .1

  ]
;  create-waters 1440
  create-waters 180
  [

  ]
  create-barycenters 1 [
    set hidden? true
  ]
  
;  ask one-of barycenters [
;    move-barycenter
;  ]  
  
  
      
    set themoon one-of moons
    set earth one-of earths
    set grav one-of gravitations
    set embarycenter one-of barycenters
  
  
  layout-circle waters 10

ask waters 
    [
      set color blue
      set size 1
      set vx [vx] of earth
      set vy [vy] of earth
      set mass .5
    ]
    
    
  
  ;; follow earth at first
  ;;follow one-of earths  
  
  
end


to go

  
  ;; first clear old acceleration variables
  ask turtles [set ax 0 set ay 0]
  ;; then calculate new acceleration to all turtls
  ask earths [ calc-earth-acceleration ]
  ask waters [ calc-waters-acceleration ]
  ;ask waters [ earth-push-water ]
  ask moons [ calc-moon-acceleration ]
  ;; then change their velocities according to acceleration
  ask turtles [ add-acceleration ]
  ;; then move them
  ask turtles [ move ]
  ;; set the gravitational center between moon and earth
  ask earths [find-center]
  
  ask waters [add-friction]
  
  tick

end

to find-center
  let d distance themoon
  let h towards themoon
  let reldistance d * [mass] of themoon / (mass + [mass] of themoon)
;  let reldistance [mass] of amoon / (mass + [mass] of amoon)
  ask barycenters [setxy ([xcor] of myself + sin(h) * reldistance) ([ycor] of myself + cos(h) * reldistance)]
  
end


to calc-earth-acceleration

  let d distance themoon
  let h towards themoon
  let relativegravity [mass] of themoon / ([mass] of themoon + [mass] of self)
  let force ([mass] of self + [mass] of themoon) / d ^ 2 
;  show force
  set ax force * sin h * relativegravity
  set ay force * cos h * relativegravity

;; adding this accelration to waters too

  ask waters [
    set ax ax + force * sin h * relativegravity
    set ay ay + force * cos h * relativegravity
  ]


end

to calc-moon-acceleration
  let d distance earth
  let h towards earth
  let relativegravity [mass] of earth / ([mass] of earth + [mass] of self)
  let force ([mass] of self * [mass] of earth) / d ^ 2   
;  show force
  
  set ax force * sin h * relativegravity
  set ay force * cos h * relativegravity
  

end

to calc-waters-acceleration
  ; find heading towards earth
  let h towards earth
  ; reverse it
  set h h - 180
  ; place gravation at radius of earth away from earth
  ask grav [setxy ([xcor] of earth + sin h * 10) ([ycor] of earth + cos h * 10)]
  
  ;; if water is already exactly on surface of earth, no acceleration
   ifelse (xcor = [xcor] of grav and ycor = [ycor] of grav)
    [
      set ax ay
      set ay ax
    ]
    ;; if water is "below earth's surface", pull it towards grav
   [
   ifelse (towards earth != towards grav)
    [
      ; now pull water towards grav
      set h towards grav
      ; find distance to grav
      let d distance grav
      ; the closer it is, the less it pulls or pushes
      
      let force d / 8
      set ax force * sin h
      set ay force * cos h

    ]
    ;; if water is above earth's surface, pull it towards grav by a bit less
    [
      ; now pull water towards grav
      set h towards grav
      ; find distance to grav
      let d distance grav
      ; the closer it is, the less it pulls or pushes
      
      let force d / 10
      set ax force * sin h
      set ay force * cos h
;      
    ]
    
   ]
   
  ; now for gravity between water and moon
  ; first moon pulls water
  let d distance themoon
  set h towards themoon
;  let relativegravity [mass] of themoon / ([mass] of themoon + [mass] of self)
  let relativegravity 1
  let force .03
;  let force ([mass] of self * [mass] of themoon) / d ^ 2   
  set ax ax + force * sin h * relativegravity
  set ay ay + force * cos h * relativegravity
  ; then water pulls moon 
  ask themoon [
    set ax ax + force * sin (h - 180) * relativegravity
    set ay ay + force * cos (h - 180) * relativegravity
  ]
  

  
  ; add push between waters
    ask waters with [who != [who] of myself and xcor != [xcor] of myself and ycor != [ycor] of myself]
    [
      if distance myself < 3
      [
        set h towards myself
        set force wpush / distance myself
        set ax ax + force * sin (h - 180)
        set ay ay + force * cos (h - 180)
        ]

    ]
end


to add-friction
  
  set vx vx * friction
  set vy vy * friction
  
end

to add-acceleration
  set vx vx + ax
  set vy vy + ay

end

to move
  setxy xcor + vx ycor + vy
end

to earth-push-water
  let d distance earth
  let h towards earth + 180
  let force ([mass] of self * [mass] of earth) / d ^ 2
 ; show force
;  show force
  set ax ax + force * sin h / [mass] of self
  set ay ay + force * cos h / [mass] of self

end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
1022
843
200
200
2.0
1
10
1
1
1
0
1
1
1
-200
200
-200
200
0
0
1
ticks
30.0

BUTTON
10
212
76
245
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
131
212
194
245
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
8
251
201
284
earth-mass
earth-mass
0
200
135
1
1
NIL
HORIZONTAL

SLIDER
8
287
207
320
moon-mass
moon-mass
0
20
19
1
1
NIL
HORIZONTAL

BUTTON
1
325
111
358
Follow moon
ask barycenters [set hidden? true]\\nfollow one-of moons
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
112
325
218
358
Follow Earth
ask embarycenter [set hidden? true]\\nfollow one-of earths
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1
359
145
392
Follow barycenter
ask embarycenter [set hidden? true]\\nfollow embarycenter
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1
392
119
425
NIL
clear-drawing
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1
424
64
457
draw
ask earth [pen-down]\\nask themoon [pen-down]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
63
424
156
457
stop draw
ask turtles [pen-up]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
473
96
506
Reset P
reset-perspective
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
10
153
182
186
wpush
wpush
0
15
0.03
.3
1
NIL
HORIZONTAL

SLIDER
13
79
185
112
friction
friction
0
1
0.87
0.01
1
NIL
HORIZONTAL

@#$#@#$#@
## ## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## ## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## ## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## ## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## ## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## ## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## ## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## ## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## ## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0RC7
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
