globals [
  bank-loans
  new-loan
  x-max
  y-max
]


turtles-own [
  assets
  debt
  income
  interest-expense
  net-income
  portfolio-investments
  portfolio-cash
  risk-tolerance
  wealth
  ]


to setup
  clear-all
  ask turtles [initialize-variables]
  ask patches [set pcolor green]
  set-default-shape turtles "person"
  create-turtles people [setup-turtles]
  set x-max 300
  set y-max 300
  reset-ticks
end

to initialize-variables
  set bank-loans 0
  set new-loan 0
  set assets initial-wealth
  set debt 0
  set income 0
  set interest-expense 0
  set net-income 0
  set portfolio-investments 0
  set portfolio-cash initial-wealth
  set risk-tolerance 0
  set wealth initial-wealth
end

to setup-turtles   ;; turtle procedure
  setxy random-xcor random-ycor

  ;; setup three risk-preferences
  set risk-tolerance random 3
    ;; 0 = conservative, 1 = moderate, 2 = agressive investors

    if risk-tolerance = 0 [
      set color black
        ;; 20% of portfolio is in cash
      set portfolio-cash (initial-wealth * .2)
        ;; 80% of portfolio is in earning assets
      set portfolio-investments (initial-wealth - portfolio-cash)
        ;; total assets of investor
      set assets (portfolio-cash + portfolio-investments)
        ;; wealth is the investors equity
      set wealth (assets - debt)
    ]

    if risk-tolerance = 1 [
      set color white
        ;; 10% of portfolio is in cash
      set portfolio-cash (initial-wealth * .1)
        ;; 90% of portfolio is in earning assets
      set portfolio-investments (initial-wealth - portfolio-cash)
      set assets (portfolio-cash + portfolio-investments)
      set wealth (assets - debt)
    ]

    if risk-tolerance = 2 [
      set color red
        ;; 5% of portfolio is in cash
      set portfolio-cash (initial-wealth * .05)
        ;; 95% of portfolio is in earning assets
      set portfolio-investments (initial-wealth - portfolio-cash)
      set assets (portfolio-cash + portfolio-investments)
      set wealth (assets - debt)
    ]
end


to go
  ;; Update balances from time period (t-1)
  ask turtles [ update ]

    ask turtles [
      if risk-tolerance = 0 [
        set interest-expense (debt * (loan-interest-rate / 100))
        set net-income (income - interest-expense)
          ;; earnings before interest and taxes
        set income (assets * (earnings-rate / 100))
          ;; total assets of investor
        set assets (portfolio-cash + portfolio-investments)
        set wealth (assets)    ;; net worth of investor
      ]
    ]

    ask turtles [
      if risk-tolerance = 1 [

        set income ((earnings-rate / 100) * portfolio-investments)
        set interest-expense (debt * (loan-interest-rate / 100))
        set net-income (income - interest-expense)
        set wealth (wealth + income)
          ;; lender makes an 80% loan against assets of moderate investor
        set new-loan (income * .8)
        set debt (debt + new-loan)
        set assets (debt + wealth)
        if wealth <= 0 [die]   ;; if wealth goes negative, turtle dies
      ]
    ]

    ask turtles [
      set income ((earnings-rate / 100) * portfolio-investments)
        set interest-expense (debt * (loan-interest-rate / 100))
        set net-income (income - interest-expense)
        set wealth (wealth + income)
          ;; lender makes an 50% loan against assets of agressive investor
        set new-loan (income * .5)
        set debt (debt + new-loan)
        set assets (debt + wealth)
        if wealth <= 0 [die]   ;; if wealth goes negative, turtle dies
      ]

  ask turtles [ move ]
  tick
end

to update
  ;; earnings on securities before interest and taxes
  set income (portfolio-investments * (earnings-rate / 100))
  ;; interest expense on outstanding debt
  set interest-expense (debt * (loan-interest-rate / 100))
  set net-income (income - interest-expense)
  ;; reinvest net income in the portfolio
  ifelse (risk-tolerance = 1)
    [update-one]   ;; moderate invesor splits portfolio 90-10
    [if (risk-tolerance = 2)
      [update-two] ;; agressive investor splits portfolio 95-5
    ]

end

to update-one
  set portfolio-investments (net-income * .9) ;; give 90% to earning assets
  set portfolio-cash (net-income * .1)  ;; give 10% to non-earning cash
end

to update-two
  set portfolio-investments (net-income * .95) ;; give 95% to earning assets
  set portfolio-cash (net-income * .05)  ;; give 5% to non-earning assets
end



to move
  rt random-float 360
  fd 1
end


to-report wealth-total
  report sum [wealth] of turtles
end


to-report debt-total
  report sum [debt] of turtles
end


to-report assets-total
  report sum [assets] of turtles
end


to-report income-total
  report sum [income] of turtles
end

to-report net-income-total
  report sum [net-income] of turtles
end

to-report interest-expense-total
  report sum [interest-expense] of turtles
end

to-report portfolio-cash-total
  report sum [portfolio-cash] of turtles
end

to-report portfolio-investments-total
  report sum [portfolio-investments] of turtles
end
@#$#@#$#@
GRAPHICS-WINDOW
516
22
830
337
-1
-1
18.0
1
10
1
1
1
0
1
1
1
-8
8
-8
8
1
1
1
ticks
30.0

SLIDER
8
10
138
43
people
people
0.0
200.0
100.0
1.0
1
NIL
HORIZONTAL

SLIDER
144
10
278
43
initial-wealth
initial-wealth
0.0
100.0
100.0
1.0
1
NIL
HORIZONTAL

BUTTON
28
99
117
136
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
166
95
253
132
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
4
350
247
548
Wealth & Debt
Time
Mny + Lns
0.0
300.0
-50.0
600.0
true
true
"set-plot-x-range 0 x-max\nset-plot-y-range -50 y-max" ""
PENS
"cash" 1.0 0 -16777216 true "" "plot portfolio-cash-total"
"debt" 1.0 0 -2674135 true "" "plot debt-total"

MONITOR
145
245
273
290
Net-income-total
net-income-total
2
1
11

MONITOR
147
292
275
337
Earning-assets-total
portfolio-investments-total
2
1
11

MONITOR
11
195
136
240
Debt-total
debt-total
2
1
11

MONITOR
11
293
139
338
Portfolio-cash-total
portfolio-cash-total
2
1
11

MONITOR
10
244
138
289
Interest-expense-total
interest-expense-total
2
1
11

PLOT
250
350
510
548
Income & Expense
Time
Svngs + Wllts
0.0
300.0
-50.0
600.0
true
true
"set-plot-x-range 0 x-max\nset-plot-y-range -50 y-max" ""
PENS
"income" 1.0 0 -13345367 true "" "plot income-total"
"expense" 1.0 0 -10899396 true "" "plot interest-expense-total"

PLOT
521
351
829
546
Wealth Distribution Histogram
poor <--------> rich
People
0.0
100.0
0.0
57.0
false
false
"set-plot-y-range 0 (count turtles)" ""
PENS
"hist" 1.0 0 -13345367 true "" "if( ticks mod 10 = 1 ) [\n  let max-wealth max [wealth] of turtles\n  let min-wealth min [wealth] of turtles\n  let one-fifth-wealth 0.2 * (max-wealth - min-wealth)\n  let num-bins 10\n  let index 1\n  let interval round ((plot-x-max - plot-x-min) / num-bins)\n  plot-pen-reset\n  repeat num-bins [\n    plotxy ((index - 1) * interval + 0.002)\n                 (count turtles with [\n                      wealth < (min-wealth + index * one-fifth-wealth) and\n                      wealth >= (min-wealth + (index - 1) * one-fifth-wealth)\n                  ]\n                 )\n\n    plotxy  (index * interval)\n                 (count turtles with [\n                      wealth < (min-wealth + index * one-fifth-wealth) and\n                      wealth >= (min-wealth + (index - 1) * one-fifth-wealth)\n                  ]\n                 )\n\n    plotxy (index * interval + 0.001) 0\n    set index index + 1\n  ]\n]"

TEXTBOX
414
27
524
83
Red (Agressive)\nWhite (Moderate)  \nBlack (Conservative)
11
0.0
1

MONITOR
146
195
274
240
Assets-total
assets-total
2
1
11

PLOT
292
195
493
335
Leverage vs Earnings
leverage
earnings
0.0
10.0
0.0
10.0
true
true
"set-plot-x-range 0 x-max\nset-plot-y-range 0 (count turtles)" ""
PENS
"earnings" 1.0 0 -16777216 true "" "plot income-total"
"debt" 1.0 0 -7500403 true "" "plot debt-total"

SLIDER
145
50
278
83
loan-interest-rate
loan-interest-rate
0
10
5.75
.25
1
NIL
HORIZONTAL

SLIDER
7
51
137
84
earnings-rate
earnings-rate
0
10
6.0
.25
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

The model looks at financial leverage, risk, reward and outcomes from portfolios of three different types: CONSERVATIVE-INVESTORS, MODERATE-INVESTORS, and AGRESSIVE-INVESTORS. Investors use their INITIAL-WEALTH to fund a PORTFOLIO-CASH fund and to buy EARNING-ASSETS.  Cash is assumed to be a non-earning asset in the investor's portfolio.  Based on their randomly assigned RISK-TOLERANCE investors may obtain loans from lenders to buy more securities.

Lenders charge DEBT-INTEREST and limit their loans to a certain percentage of the investors assets, which are pledged as security. LOAN-INTEREST-RATE and PORTFOLIO SECURITIES ARE set from sliderS by risk level).  The objective is to see what changes in investor WEALTH take place for the three levels of RISK-TOLERANCE given the existence of positive or negative leverage.  If the cost to borrow exceeds the income earned, there is negative leverage and the investor eventually goes broke. 

## HOW IT WORKS

The setup for the model initializes variables and randomly assigns investor RISK-TOLERANCE levels.  Sliders provide values for the number of PEOPLE (investors), INITIAL-WEALTH of investors, along with and DEBT-INTEREST-RATE rate.  Assignment of RISK-TOLEERANCE utilizes a random number generator.  

Investors in the model: invest in a portfolio of cash and marketable securities; borrowing if their risk-tolerance permits.  The securities portion of their portfolio earns income and any debt bears an interest cost. Everyone starts with the same amount of INITIAL-WEALTH.

## HOW TO USE IT

The sliders determine how many investors there are, how much they have in initial wealth, and what the loan interest rate will be on any borrowing they do. 
The INITIAL-WEALTH slider sets the amount of money each investor starts out with. The PEOPLE slider sets the number of investors that will be created in the model when the SETUP button is pressed. The SETUP button resets the model: it initializes the variables, sets the color of the patches and the shape of the investors.  It randomly assigns risk-tolerance levels to the investors. The GO button starts and stops the running of the model and the plotter.

There are monitors in the interface to help the user see what is happening to investor wealth, debt and net income. WEALTH & DEBT shows the total amount of equity currently owned and the amount of debt being incurred. WEALTH & NET INCOME shows is the amount the bank has lent out, BANK-TO-LOAN is the amount that the bank has available for loan, and BANK-RESERVES is the amount the bank has been mandated to keep in reserve. When the bank must recall loans (i.e. after the reserve ratio has been raised) BANK-TO-LOAN will read a negative amount until enough of the lent money has been paid off. WALLETS-TOTAL gives an indication of the total amount of money kept in peoples' wallets. This figure may also be negative at times when the bank has no money to loan (the turtle will maintain at a negative wallet balance until a loan is possible). MONEY-TOTAL indicates the total-amount of money currently in the economy (SAVINGS-TOTAL + WALLETS-TOTAL).  Because WALLETS-TOTAL is generally kept at 0 in this model (we are assuming that everyone deposits all they can in savings), MONEY-TOTAL and SAVINGS TOTAL tend to be the the same.

A person's color tells us which risk profile it is in.

## THINGS TO NOTICE

All investors begin with the same amount of wealth, but with different portfolio compositions.  Only two of the three investor risk-tolerance profiles can borrow money, which they do to the maximum available degree.  Lenders only make loans with a pledge of assets in percentages based on historical numbers.  Portfolios are broken down into two parts:  an earning part (securities) and a non-earning cash part.  Cash doesn't earn anything in this model, so having more of it reduces the total portfolio return.  The earnings rate on securities is based on historical figures and with the addition of non-earning cash the total portfolio earnings rate will be somewhat less.

When portfolio earnings rate is greater than the loan interest rate, the effect on net income is positive.  If it is less, the effect is negative.  Where they equal each other, the effect is neutral.  This model does not consider the effect of taxes on outcomes.


## THINGS TO TRY

Vary the interest rates and see what the effect this has on WEALTH.  

Set EARNINGS-RATE initially to 10, and watch the effect on WEALTH. Now try lowering EARNINGS-RATE so it equals the selected LOAN-INTEREST-RATE.  If the cost of debt exceeds the EARNINGS-RATE there is a negative effect on WEALTH.  Exogenous changes to those rates can increase financial risk.


## EXTENDING THE MODEL

Try extending the model to include changes in the market value of the investor's portfolio, where the lender requires more or less security for their loans.  Financial leverage is a source of systemic risk in the world economy.

This model has turtles interact in a very simple way and earnings are before taxes.  You could add taxation of income and see what effect that might have on use of leverage.

## RELATED MODELS

This model was created based on BANK RESERVES in the NetLogo library.

## HOW TO CITE



This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
